/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blockentities;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;

public class BNBrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] TOP_SLOTS = new int[]{3};
    private static final int[] BOTTOM_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] SIDE_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int brewTime;
    private boolean[] slotsEmptyLastTick;
    private Item itemBrewing;
    private int fuel;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BNBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return BNBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BNBrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    BNBrewingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public BNBrewingStandBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntitiesRegistry.NETHER_BREWING_STAND, blockPos, blockState);
    }

    protected Component m_6820_() {
        return Component.m_237110_((String)"container.brewing", (Object[])new Object[0]);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        ItemStack itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).m_41619_());
        return false;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BNBrewingStandBlockEntity blockEntity) {
        boolean[] bls;
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(4);
        if (blockEntity.fuel <= 0 && itemStack.m_41720_() == Items.f_42593_) {
            blockEntity.fuel = 20;
            itemStack.m_41774_(1);
            BNBrewingStandBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        boolean bl = blockEntity.canCraft();
        boolean bl2 = blockEntity.brewTime > 0;
        ItemStack itemStack2 = (ItemStack)blockEntity.inventory.get(3);
        if (bl2) {
            boolean bl3;
            --blockEntity.brewTime;
            boolean bl4 = bl3 = blockEntity.brewTime == 0;
            if (bl3 && bl) {
                blockEntity.craft();
                BNBrewingStandBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            } else if (!bl) {
                blockEntity.brewTime = 0;
                BNBrewingStandBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            } else if (blockEntity.itemBrewing != itemStack2.m_41720_()) {
                blockEntity.brewTime = 0;
                BNBrewingStandBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            }
        } else if (bl && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 400;
            blockEntity.itemBrewing = itemStack2.m_41720_();
            BNBrewingStandBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (!blockEntity.f_58857_.f_46443_ && !Arrays.equals(bls = blockEntity.getSlotsEmpty(), blockEntity.slotsEmptyLastTick)) {
            blockEntity.slotsEmptyLastTick = bls;
            BlockState blockState = state;
            if (!(blockState.m_60734_() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockState = (BlockState)blockState.m_61124_((Property)BrewingStandBlock.f_50905_[i], (Comparable)Boolean.valueOf(bls[i]));
            }
            blockEntity.f_58857_.m_7731_(pos, blockState, 2);
        }
    }

    public boolean[] getSlotsEmpty() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            bls[i] = true;
        }
        return bls;
    }

    private boolean canCraft() {
        ItemStack source = (ItemStack)this.inventory.get(3);
        if (source.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)source)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.m_41619_()) continue;
            if (PotionBrewing.m_43508_((ItemStack)bottle, (ItemStack)source)) {
                return true;
            }
            if (BrewingRegistry.getResult(source, bottle) == null) continue;
            return true;
        }
        return false;
    }

    private void craft() {
        this.craft(this.f_58857_, this.f_58858_, this.m_58900_());
    }

    private void craft(Level world, BlockPos blockPos, BlockState state) {
        ItemStack source = (ItemStack)this.inventory.get(3);
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.m_41619_()) continue;
            ItemStack result = BrewingRegistry.getResult(source, bottle);
            if (result != null) {
                this.inventory.set(i, (Object)result.m_41777_());
                continue;
            }
            this.inventory.set(i, (Object)PotionBrewing.m_43529_((ItemStack)source, (ItemStack)((ItemStack)this.inventory.get(i))));
        }
        source.m_41774_(1);
        if (source.m_41720_().m_41470_()) {
            ItemStack itemStack2 = new ItemStack((ItemLike)source.m_41720_().m_41469_());
            if (source.m_41619_()) {
                source = itemStack2;
            } else if (!world.f_46443_) {
                Containers.m_18992_((Level)world, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)itemStack2);
            }
        }
        this.inventory.set(3, (Object)source);
        this.f_58857_.m_46796_(1035, blockPos, 0);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.brewTime = tag.m_128448_("BrewTime");
        this.fuel = tag.m_128445_("Fuel");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        tag.m_128344_("Fuel", (byte)this.fuel);
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 3) {
            return PotionBrewing.m_43506_((ItemStack)stack);
        }
        Item item = stack.m_41720_();
        if (slot == 4) {
            if (item == Items.f_42593_) {
                return true;
            }
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            return id.m_135827_().equals("biomemakeover") && id.m_135815_().equals("soul_embers");
        }
        return (item == Items.f_42589_ || item == Items.f_42736_ || item == Items.f_42739_ || item == Items.f_42590_) && this.m_8020_(slot).m_41619_();
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return side == Direction.DOWN ? BOTTOM_SLOTS : SIDE_SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        if (slot == 3) {
            return stack.m_41720_() == Items.f_42590_;
        }
        return true;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new BrewingStandMenu(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }
}

